/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.truststore.service.persistence;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.signals.truststore.service.persistence.TruststoreData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentType;

public class TruststoreRepository {
    private final PrivilegedConfigClient client;

    public TruststoreRepository(PrivilegedConfigClient client) {
        this.client = Objects.requireNonNull(client, "Node client is required");
    }

    public IndexResponse createOrReplace(String truststoreId, TruststoreData truststoreData) {
        Objects.requireNonNull(truststoreId, "Truststore id is required");
        Objects.requireNonNull(truststoreData, "Truststore data are required");
        String json = truststoreData.toJsonString();
        IndexRequest storeRequest = ((IndexRequest)new IndexRequest(".signals_truststores").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).id(truststoreId).source(json, XContentType.JSON);
        return (IndexResponse)this.client.index(storeRequest).actionGet();
    }

    public List<TruststoreData> findAll() {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        sourceBuilder.sort("store_time");
        SearchResponse searchResponse = (SearchResponse)this.client.search(new SearchRequest(new String[]{".signals_truststores"}).source(sourceBuilder)).actionGet();
        try {
            return this.searchResponseToTruststores(searchResponse);
        }
        catch (ConfigValidationException e) {
            throw new RuntimeException("Cannot parse trust store content stored in an index.", e);
        }
    }

    public Optional<TruststoreData> findOneById(String truststoreId) {
        Objects.requireNonNull(truststoreId, "Trust store id is required");
        GetResponse getResponse = (GetResponse)this.client.get(new GetRequest(".signals_truststores").id(truststoreId)).actionGet();
        try {
            return this.getResponseToTruststoreData(getResponse);
        }
        catch (ConfigValidationException e) {
            throw new RuntimeException("Cannot parse trust store '" + truststoreId + "' content stored in an index.", e);
        }
    }

    private Optional<TruststoreData> getResponseToTruststoreData(GetResponse response) throws ConfigValidationException {
        return response.isExists() ? Optional.of(this.jsonToTruststoreData(response.getId(), response.getSourceAsString())) : Optional.empty();
    }

    private List<TruststoreData> searchResponseToTruststores(SearchResponse searchResponse) throws ConfigValidationException {
        ArrayList<TruststoreData> list = new ArrayList<TruststoreData>();
        for (SearchHit hit : searchResponse.getHits().getHits()) {
            TruststoreData truststoreData = this.searchHitToTruststoreData(hit);
            list.add(truststoreData);
        }
        return list;
    }

    private TruststoreData searchHitToTruststoreData(SearchHit searchHit) throws ConfigValidationException {
        return this.jsonToTruststoreData(searchHit.getId(), searchHit.getSourceAsString());
    }

    private TruststoreData jsonToTruststoreData(String truststoreId, String json) throws ConfigValidationException {
        DocNode docNode = TruststoreRepository.parseJsonAsDocNode(json);
        return new TruststoreData(truststoreId, docNode);
    }

    private static DocNode parseJsonAsDocNode(String json) throws DocumentParseException {
        return DocNode.parse((Format)Format.JSON).from(json);
    }

    public Boolean deleteById(String truststoreId) {
        Objects.requireNonNull(truststoreId, "Truststore id is required");
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(".signals_truststores").id(truststoreId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        DeleteResponse deleteResponse = (DeleteResponse)this.client.delete(deleteRequest).actionGet();
        return RestStatus.OK.equals((Object)deleteResponse.status());
    }
}

